/** @file   flamerai.h
 * @brief   Declaration of FlamerAi - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_FLAMERAI_H
#define H_WWW_FLAMERAI_H

#include "minigunai.h"

namespace WeWantWar {


/** @class  FlamerAi
 * @brief   Controls the FlamerAlien.
 * @author  Tomi Lamminsaari
 *
 * Has its own class since we need to give some initial values to the
 * parameters.
 */
class FlamerAi : public MinigunAI
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   * @param     aObj              Pointer to GameObject we're supposed to
   *                              control.
   */
	FlamerAi( GameObject* aObj );


	/** Destructor
   */
	virtual ~FlamerAi();

private:

	/** Copy constructor.
   * @param     rO                Reference to another FlamerAi
   */
  FlamerAi( const FlamerAi& rO );

	/** Assignment operator
   * @param     rO                Reference to another FlamerAi
   * @return    Reference to us.
   */
  FlamerAi& operator = ( const FlamerAi& rO );

public:


  ///
  /// Methods
  /// =======



  ///
  /// Getter methods
  /// ==============


protected:

  ///
  /// Members
  /// =======



private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif


/**
 * Version history
 * ===============
 * $Log: flamerai.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:56+02  lamminsa
 * Initial revision
 *
 */
 
